<?php
/**
 * XtraUpload
 *
 * A turn-key open source web 2.0 PHP file uploading package requiring PHP v5
 *
 * @package		XtraUpload
 * @author		Matthew Glinski
 * @copyright	Copyright (c) 2006, XtraFile.com
 * @license		http://xtrafile.com/docs/license
 * @link		http://xtrafile.com
 * @since		Version 2.0
 * @filesource
 */

// ------------------------------------------------------------------------

/**
 * XtraUpload Cron Controller
 *
 * @package		XtraUpload
 * @subpackage	Controllers
 * @category	Controllers
 * @author		Matthew Glinski
 * @link		http://xtrafile.com/docs/cron
 */

// ------------------------------------------------------------------------

class Cron extends Controller 
{
	private $server = false;
	
	public function Cron()
	{
		parent::Controller();
		if(!defined('IN_CRON'))
		{
			show_404();	
		}
		
		$this->server = base_url();
		$this->_runCron();
	}
	
	function index()
	{
		return;	
	}
	
	function _runCron()
	{
		// run plugin cron files
		$this->_extendCron();
	}
	
	function _extendCron()
	{
		$dir = APPPATH."cron";
		$files = opendir($dir);
		
		// Look in the folder for cron files
		while ($file = readdir($files))
		{
			$code = substr($file, 0, 2);
			if ((substr($file, -4, 4) == '.php') and !is_dir($dir .'/'. $file) and !stristr($file, '_no_load'))
			{
				$name = str_replace('.php', '', $file);
				include_once($dir .'/'. $file);
				$cron_extend = new $name($this->server);
				unset($cron_extend);
			}
		}
		closedir ($files);
	}
}