<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');
/**
 * XtraUpload
 *
 * A turn-key open source web 2.0 PHP file uploading package requiring PHP v5
 *
 * @package		XtraUpload
 * @author		Matthew Glinski
 * @copyright	Copyright (c) 2006, XtraFile.com
 * @license		http://xtrafile.com/docs/license
 * @link		http://xtrafile.com
 * @since		Version 2.0
 * @filesource
 */

// ------------------------------------------------------------------------

/**
 * XtraUpload XU_API Hooks Library
 *
 * @package		XtraUpload
 * @subpackage	Library
 * @category	Library
 * @author		Matthew Glinski
 * @link		http://xtrafile.com/docs/api/hooks
 */

// ------------------------------------------------------------------------

class Xu_hooks_api
{
	private $CI = '';
	private $hooks = array();
	
	function Xu_hooks_api()
	{
		$this->CI =& get_instance();
		log_message('debug', "XtraUpload Hooks API Class Initialized");
		$this->init();
	}
	
	private function init()
	{
		return;
	}
	
	// set a hook to be run
	public function setHook($name, $function)
	{
		if(!isset($this->hooks[$name]))
		{
			$this->hooks[$name] = array();
		}
		
		$this->hooks[$name][] = $function;
	}
	
	// Run all set hooks, and return the data
	public function runHooks($name, $args)
	{
		if(!isset($this->hooks[$name]) or !is_array($this->hooks[$name]) or empty($this->hooks[$name]))
		{
			return $args;	
		}
		
		$this->CI =& get_instance();
		
		// dirty work, needs to be rethought. I hate eval statments... 
		foreach($this->hooks[$name] as $function)
		{
			$args = $function($args);
		}
		return $args;
	}
	
	// [SYSTEM] -> return the raw hooks store variable
	public function _getHooks()
	{
		return $this->hooks;
	}
	
	// [SYSTEM] -> apply the raw hooks store variable
	public function _putHooks($hooks)
	{
		$this->hooks = $hooks;
	}
}
?>