<?php

// includes and security
include_once('../../../../core/includes/master.inc.php');
include_once(DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');

// load our payment object for later
$pluginObj = pluginHelper::getInstance('payment');

// preload available gateways for select
$availableGateways = $pluginObj->getAvailableGateways();

// prepare variables
$server_label = '';

// is this an edit?
$gatewayConfigId = null;
$gatewayId = null;
if((isset($_REQUEST['gEditGatewayId'])) && ((int) $_REQUEST['gEditGatewayId'])) {
    $sQL = "SELECT * FROM plugin_payment_gateways_configured WHERE id=" . (int)$_REQUEST['gEditGatewayId'] ." LIMIT 1";
    $gatewayConfigDetails = $db->getRow($sQL);
    if($gatewayConfigDetails) {
        $gatewayConfigId = $gatewayConfigDetails['id'];
        $gatewayId = $gatewayConfigDetails['gateway_id'];
    }
}

// prepare result
$result = array();
$result['error'] = false;
$result['msg'] = '';

$result['html'] .= '<form id="enableGatewayForm" class="form-horizontal form-label-left input_mask">
                        <div class="x_panel">
                            <div class="x_content">
                                            <div class="x_title">
                                                <h2>Configure Gateway</h2>
                                                <div class="clearfix"></div>
                                            </div>';

$result['html'] .= '                        <p>Use the form below to integrate with a new payment gateway.</p>';

$result['html'] .= '                        <div class="form-group">
                                                <label class="control-label col-md-3 col-sm-3 col-xs-12">' . UCWords(adminFunctions::t("select_gateway", "select gateway")) . ':</label>
                                                <div class="col-md-9 col-sm-9 col-xs-12">
                                                    <select name="gateway_id" id="gateway_id" class="form-control" onChange="loadGatewayForm(); return false;" ' . ($isDefaultServer ? 'DISABLED' : '') . '>
                                                        <optgroup label="Third Party Gateway Integration">';
                                                        
// add select options
foreach($availableGateways AS $availableGateway)
{
    $result['html'] .= '<option value="'.adminFunctions::makeSafe($availableGateway['id']).'"' . ($gatewayId == $availableGateway['id'] ? ' SELECTED' : '') . '>'.adminFunctions::makeSafe($availableGateway['label']).'</option>';
}

$result['html'] .= '                                    </optgroup>';

$result['html'] .= '                                </select>
                                                </div>
                                            </div>';
$result['html'] .= '        </div>';
$result['html'] .= '    </div>';


$result['html'] .= '                        <div class="gateway-config-wrapper"></div>';

$result['html'] .= '</div>';

if((int)$gatewayConfigId) {
    $result['html'] .= '<input type="hidden" name="gateway_config_id" id="gateway_config_id" value="'.(int)$gatewayConfigId.'"/>';
}
$result['html'] .= '</form>';

echo json_encode($result);
exit;
