<?php
// initial constants
define('ADMIN_SELECTED_PAGE', 'payment');
define('ADMIN_SELECTED_SUB_PAGE', 'gateway_manage');

// includes and security
include_once('../../../core/includes/master.inc.php');
include_once(DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');

// load plugin details
$plugin = $db->getRow("SELECT * FROM plugin WHERE folder_name = 'payment' LIMIT 1");
if(!$plugin)
{
    adminFunctions::redirect(ADMIN_WEB_ROOT . '/plugin_manage.php?error=' . urlencode('There was a problem loading the plugin details.'));
}
define('ADMIN_PAGE_TITLE', 'Manage Payment Gateways');
$pluginObj = pluginHelper::getInstance('payment');

// preload available gateways for bottom list
$availableGateways = $pluginObj->getAvailableGatewayGroups();

// make sure the plugin is enabled
if(pluginHelper::pluginEnabled('payment') === false) {
    adminFunctions::setError(adminFunctions::t("plugin_not_enabled", "Payment plugin is not enabled, please enable it before adding payment gateways."));
}

// make sure the site is using https
if(_CONFIG_SITE_PROTOCOL !== 'https') {
    adminFunctions::setError(adminFunctions::t("site_not_secure", "Your site is not running on https, some payment gateways will not allow non-https sites. It is highly recommended you install a SSL certificate on your site to avoid callback issues."));
}

// action any requests
if(isset($_REQUEST['remove_gateway_config_id'])) {
    // validate submission
    if(_CONFIG_DEMO_MODE == true) {
        adminFunctions::setError(adminFunctions::t("no_changes_in_demo_mode"));
    }
    else {
        $db->query('DELETE FROM plugin_payment_gateways_configured WHERE id = '.(int)$_REQUEST['remove_gateway_config_id'].' LIMIT 1');
    }
}

if(isset($_REQUEST['enable_gateway_config_id'])) {
    // validate submission
    if(_CONFIG_DEMO_MODE == true) {
        adminFunctions::setError(adminFunctions::t("no_changes_in_demo_mode"));
    }
    else {
        $db->query('UPDATE plugin_payment_gateways_configured SET status = "active" WHERE id = '.(int)$_REQUEST['enable_gateway_config_id'].' LIMIT 1');
    }
}

if(isset($_REQUEST['disable_gateway_config_id'])) {
    // validate submission
    if(_CONFIG_DEMO_MODE == true) {
        adminFunctions::setError(adminFunctions::t("no_changes_in_demo_mode"));
    }
    else {
        $db->query('UPDATE plugin_payment_gateways_configured SET status = "disabled" WHERE id = '.(int)$_REQUEST['disable_gateway_config_id'].' LIMIT 1');
    }
}

// prepare variables
$plugin_enabled = (int) $plugin['plugin_enabled'];
$pluginId = (int) $plugin['id'];

// page header
include_once(ADMIN_ROOT . '/_header.inc.php');
?>

<style>
    .available_payment_gateways {
        text-align: center;
    }
    .available_payment_gateways .gateway {
        display: inline-block;
        margin: 10px;
    }
    .available_payment_gateways .gateway img {
        opacity: 0.7;
        filter: alpha(opacity=70); /* msie */
        height: 40px;
    }
    .available_payment_gateways .gateway img:hover {
        opacity: 1.0;
        filter: alpha(opacity=100); /* msie */
    }
</style>

<script>
    oTable = null;
    gRequestId = null;
    gEditGatewayId = null;
    $(document).ready(function(){
        // datatable
        oTable = $('#fileTable').dataTable({
            "sPaginationType": "full_numbers",
            "bServerSide": true,
            "bProcessing": true,
            "sAjaxSource": 'ajax/gateway_list_enabled.ajax.php',
            "bJQueryUI": true,
            "iDisplayLength": 25,
            "aaSorting": [[ 1, "asc" ]],
            "aoColumns" : [
                { bSortable: false, sWidth: '3%', sName: 'file_icon', sClass: "center adminResponsiveHide" },
                { sName: 'gateway', sWidth: '15%', sClass: "adminResponsiveHide"},
                { sName: 'date_created', sWidth: '15%' , sClass: "center"},
                { sName: 'status', sWidth: '20%', sClass: "center" },
                { bSortable: false, sWidth: '15%', sClass: "center" }
            ],
            "fnServerData": function ( sSource, aoData, fnCallback ) {
                aoData.push( { "name": "filterByUser", "value": $('#filterByUser').val() } );
                $.ajax({
                    "dataType": 'json',
                    "type": "GET",
                    "url": "ajax/gateway_list_enabled.ajax.php",
                    "data": aoData,
                    "success": fnCallback
                });
            },
            "fnDrawCallback": function (oSettings) {
                postDatatableRender();
            },
            "oLanguage": {
                "sEmptyTable": "There are no items in the current filters."
            },
            dom: "lBfrtip",
            buttons: [
              {
                extend: "copy",
                className: "btn-sm"
              },
              {
                extend: "csv",
                className: "btn-sm"
              },
              {
                extend: "excel",
                className: "btn-sm"
              },
              {
                extend: "pdfHtml5",
                className: "btn-sm"
              },
              {
                extend: "print",
                className: "btn-sm"
              }
            ]
        });
        
        // update custom filter
        $('.dataTables_filter').html($('#customFilter').html());
    });

    function reloadTable()
    {
        oTable.fnDraw();
    }
    
    function addGatewayForm()
    {
        gEditGatewayId = null;
        loadAddGatewayForm();
        $('#addGatewayFormWrapper').modal("show");
    }
    
    function editGatewayForm(gatewayId)
    {
        gEditGatewayId = gatewayId;
        loadAddGatewayForm();
        $('#addGatewayFormWrapper').modal("show");
    }
    
    function loadAddGatewayForm()
    {
        $('#addGatewayForm').html('Loading...');
        $('#editGatewayForm').html('');
        $.ajax({
            type: "POST",
            url: "ajax/gateway_add_form.ajax.php",
            data: {gEditGatewayId: gEditGatewayId},
            dataType: 'json',
            success: function (json) {
                if (json.error == true)
                {
                    $('#addGatewayForm').html(json.msg);
                }
                else
                {
                    $('#addGatewayForm').html(json.html);
                    loadGatewayForm();
                }

            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                showError("Failed loading form, please try again.");
            }
        });
    }
    
    function loadGatewayForm() {
        $('.gateway-config-wrapper').html('Loading...');
        var selectedGateway = $('#gateway_id').val();
        $.ajax({
            type: "POST",
            url: "ajax/gateway_add_form_config.ajax.php",
            data: {selectedGateway: selectedGateway, gEditGatewayId: gEditGatewayId},
            dataType: 'json',
            success: function (json) {
                if (json.error == true)
                {
                    $('.gateway-config-wrapper').html(json.msg);
                }
                else
                {
                    $('.gateway-config-wrapper').html(json.html);
                }

            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                showError("Failed loading form, please try again.");
            }
        });
    }
    
    function processEnableGateway() {
        $.ajax({
            url: "ajax/gateway_add_process.ajax.php",
            type: 'POST',
            dataType: 'json',
            data: $('#enableGatewayForm').serialize(),
            success: function(json) {
                if (json.error == true) {
                    showError(json.msg);
                }
                else {
                    showSuccess(json.msg);
                    $('#addGatewayFormWrapper').modal("hide");
                    reloadTable();
                }
            },
            error: function( xhr, err ) {
                showError("Failed submitting the form, please try again.");     
            }
        });
        
    }
</script>

<div class="right_col">
    <div>
        <div class="page-title">
            <div class="title_left">
                <h3><?php echo ADMIN_PAGE_TITLE; ?></h3>
            </div>
        </div>
        <div class="clearfix"></div>
        
        <div class="row">
            <div class="col-md-12 col-sm-12 col-xs-12">
                <?php echo adminFunctions::compileNotifications(); ?>
                <form method="POST" action="gateway_manage.php" name="pluginForm" id="pluginForm" autocomplete="off" class="form-horizontal form-label-left">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>Enabled Payment Gateways</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <p>Use the table below to manage all your enabled payment gateways. To add a new gateway, click the 'Enable Payment Gateway' button below the table.</p>
                            <div class="responsiveTable">
                                <table id='fileTable' class="table table-striped table-only-border dtLoading bulk_action">
                                    <thead>
                                        <tr>
                                            <th></th>
                                            <th class="align-left"><?php echo adminFunctions::t('gateway_header', 'Gateway'); ?></th>
                                            <th class="align-left"><?php echo adminFunctions::t('date_created', 'Date Created'); ?></th>
                                            <th class="align-left"><?php echo adminFunctions::t('status', 'status'); ?></th>
                                            <th class="align-left"><?php echo adminFunctions::t('actions', 'Actions'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    
                    <div class="x_panel">
                        <div class="btn-group pull-right">
                            <a href="#" type="button" class="btn btn-primary" onclick="addGatewayForm(); return false;">Enable Payment Gateway</a>
                        </div>
                    </div>

                    <div class="x_panel">
                        <div class="x_title">
                            <h2>Available Payment Gateways</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <p>Below is the full list of available gateways. Before enabling these on your site, ensure you've checked that the gateway permits file hosting sites and you meet the minimum merchant requirements.</p>
                            <div class="available_payment_gateways">
                                <?php
                                foreach($availableGateways AS $availableGateway) {
                                    echo '<a href="'.$availableGateway['url'].'" target="_blank" rel="nofollow" class="gateway"><img src="../assets/img/gateways/'.$availableGateway['class_name'].'/logo.jpg" alt="'.$availableGateway['gateway_group'].'"/></a>';
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="customFilter" id="customFilter" style="display: none;"></div>

<div id="addGatewayFormWrapper" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header"><button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span></button></div>
            <div class="modal-body" id="addGatewayForm"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" onClick="processEnableGateway(); return false;">Save Gateway</button>
            </div>
        </div>
    </div>
</div>

<?php
include_once(ADMIN_ROOT . '/_footer.inc.php');
?>